<?php
session_start();
require_once "db.php";

$db   = new Database();
$conn = $db->connect();

/* TOTAL VOTES */
$totalVotes = (int) $conn->query("SELECT COUNT(*) FROM votes")->fetchColumn();

/* CANDIDATES + VOTES */
$stmt = $conn->query("
    SELECT 
        c.id,
        c.name,
        COUNT(v.id) AS vote_count
    FROM candidates c
    LEFT JOIN votes v ON v.candidate_id = c.id
    GROUP BY c.id
");
$candidates = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>E Voting – Results</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:'Poppins',sans-serif}
body{min-height:100vh;background:#eef6ff;display:flex;justify-content:center;padding:40px 0}

.page-card{
    width:1100px;max-width:95%;background:#fff;border-radius:16px;
    padding:40px;box-shadow:0 10px 25px rgba(0,123,255,.15);position:relative
}

.total-votes{
    position:absolute;top:30px;left:30px;background:#e3f2fd;
    padding:14px 20px;border-radius:12px;border:1px solid #bbdefb
}

.total-votes h4{font-size:13px;color:#1e88e5}
.total-votes span{font-size:22px;font-weight:600;color:#0d47a1}

.add-btn{
    position:absolute;top:30px;right:30px;
    background:linear-gradient(135deg,#64b5f6,#1e88e5);
    color:#fff;border:none;padding:12px 20px;border-radius:30px;
    cursor:pointer;font-size:14px
}

.page-header{text-align:center;margin-bottom:50px}
.page-header img{width:64px;margin-bottom:12px}
.page-header h1{font-size:26px;color:#0d47a1}
.page-header p{font-size:14px;color:#5f7da3}

.results-list{display:flex;flex-direction:column;gap:24px}

.result-card{
    background:#f8fbff;border-radius:14px;padding:24px;border:1px solid #dbe8f7
}

.result-top{
    display:flex;justify-content:space-between;align-items:center;margin-bottom:12px
}

.result-top h3{font-size:16px;color:#0d47a1}
.result-top span{font-size:14px;color:#1e88e5}

.progress{
    width:100%;height:10px;background:#e3f2fd;border-radius:10px;
    overflow:hidden;margin-bottom:10px
}

.progress-bar{
    height:100%;background:linear-gradient(135deg,#64b5f6,#1e88e5)
}

.votes-info{font-size:13px;color:#5f7da3;margin-bottom:12px}

.delete-btn{
    background:#e53935;color:#fff;border:none;
    padding:10px 18px;border-radius:30px;
    cursor:pointer;font-size:13px
}

/* MODAL */
.modal-overlay{
    position:fixed;inset:0;background:rgba(0,0,0,.45);
    display:none;align-items:center;justify-content:center;
    z-index:1000
}

.modal{
    background:#fff;padding:30px;border-radius:14px;
    width:420px;max-width:90%;text-align:center
}

.modal h3{color:#0d47a1;margin-bottom:10px}
.modal p{font-size:14px;color:#5f7da3;margin-bottom:25px}

.modal-actions{
    display:flex;gap:12px;justify-content:center
}

.modal-actions button{
    padding:12px 22px;border-radius:30px;
    border:none;cursor:pointer;font-size:14px
}

.confirm-btn{background:#e53935;color:#fff}
.cancel-btn{background:#e3f2fd;color:#0d47a1}

@media(max-width:600px){
    .total-votes,.add-btn{position:static;margin-bottom:15px}
    .page-card{padding:30px 20px}
}
</style>
</head>

<body>

<div class="page-card">

    <div class="total-votes">
        <h4>Total Votes</h4>
        <span><?= $totalVotes ?></span>
    </div>

    <a href="add_candidate.php">
        <button class="add-btn">Add candidate +</button>
    </a>

    <div class="page-header">
        <img src="votinglogo.jpg">
        <h1>Election Results</h1>
        <p>Live voting results overview</p>
    </div>

    <div class="results-list">
        <?php foreach ($candidates as $c):
            $votes = (int)$c["vote_count"];
            $percent = $totalVotes ? round(($votes/$totalVotes)*100) : 0;
        ?>
        <div class="result-card">
            <div class="result-top">
                <h3><?= htmlspecialchars($c["name"]) ?></h3>
                <span><?= $percent ?>%</span>
            </div>

            <div class="progress">
                <div class="progress-bar" style="width:<?= $percent ?>%"></div>
            </div>

            <div class="votes-info"><?= $votes ?> Votes</div>

            <button 
                class="delete-btn"
                onclick="openModal(<?= $c['id'] ?>,'<?= htmlspecialchars($c['name'],ENT_QUOTES) ?>')">
                Delete candidate
            </button>
        </div>
        <?php endforeach; ?>
    </div>

</div>

<!-- CONFIRM MODAL -->
<div class="modal-overlay" id="confirmModal">
    <div class="modal">
        <h3>Delete Candidate</h3>
        <p>Are you sure you want to delete <strong id="candidateName"></strong>?</p>

        <form method="POST" action="delete_candidate.php">
            <input type="hidden" name="candidate_id" id="candidateId">
            <div class="modal-actions">
                <button type="submit" class="confirm-btn">Yes, delete</button>
                <button type="button" class="cancel-btn" onclick="closeModal()">No, cancel</button>
            </div>
        </form>
    </div>
</div>

<script>
function openModal(id,name){
    document.getElementById("candidateId").value = id;
    document.getElementById("candidateName").textContent = name;
    document.getElementById("confirmModal").style.display = "flex";
}

function closeModal(){
    document.getElementById("confirmModal").style.display = "none";
}
</script>

</body>
</html>
