<?php
class User {
    private $conn;
    private $table = "users";

    public function __construct($db) {
        $this->conn = $db;
    }

    // REGISTER USER
    public function register($name, $email, $year_of_birth, $password) {
        $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

        $query = "INSERT INTO {$this->table}
                  (name, user_email, year_of_birth, password)
                  VALUES (:name, :email, :yob, :password)";

        $stmt = $this->conn->prepare($query);
        return $stmt->execute([
            ':name' => $name,
            ':email' => $email,
            ':yob' => $year_of_birth,
            ':password' => $hashedPassword
        ]);
    }

    // LOGIN USER
    public function login($email, $password) {
        $query = "SELECT * FROM {$this->table} WHERE user_email = :email LIMIT 1";
        $stmt = $this->conn->prepare($query);
        $stmt->execute([':email' => $email]);

        if ($stmt->rowCount() === 1) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if (password_verify($password, $user['password'])) {
                return $user;
            }
        }
        return false;
    }

    // CHECK IF USER HAS VOTED
    public function hasVoted($user_id) {
        $query = "SELECT has_voted FROM {$this->table} WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        $stmt->execute([':id' => $user_id]);

        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['has_voted'] == 1;
    }

    // MARK USER AS VOTED
    public function markAsVoted($user_id) {
        $query = "UPDATE {$this->table} SET has_voted = 1 WHERE id = :id";
        $stmt = $this->conn->prepare($query);
        return $stmt->execute([':id' => $user_id]);
    }
}
