<?php
require_once "db.php";
require_once "user.php";

$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $name     = trim($_POST["name"]);
    $email    = trim($_POST["email"]);
    $year     = trim($_POST["year"]);
    $password = $_POST["password"];
    $confirm  = $_POST["confirm_password"];

    if ($password !== $confirm) {
        $message = "Passwords do not match";
    } else {
        try {
            $db = new Database();
            $conn = $db->connect();
            $user = new User($conn);

            $check = $conn->prepare("SELECT id FROM users WHERE user_email = ?");
            $check->execute([$email]);

            if ($check->rowCount() > 0) {
                $message = "Email already registered";
            } else {
                if ($user->register($name, $email, $year, $password)) {
                    header("Location: index.php");
                    exit;
                } else {
                    $message = "Registration failed. Try again.";
                }
            }

        } catch (Exception $e) {
            $message = "Error: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>E Voting Registration</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Poppins', sans-serif;
}

body {
    min-height: 100vh;
    background: #eef6ff;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

.signup-card {
    width: 780px;
    max-width: 100%;
    background: #ffffff;
    border-radius: 14px;
    padding: 40px;
    box-shadow: 0 10px 25px rgba(0, 123, 255, 0.15);
    text-align: center;
}

.logo {
    width: 64px;
    height: 64px;
    margin: 0 auto 12px;
}

.logo img {
    width: 100%;
    height: 100%;
    object-fit: contain;
}

.signup-card h1 {
    font-size: 24px;
    font-weight: 600;
    margin-bottom: 25px;
    color: #0d47a1;
}

.form-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 18px 22px;
    text-align: left;
}

.form-group {
    width: 100%;
}

.form-group.full {
    grid-column: span 2;
}

.form-group label {
    display: block;
    font-size: 14px;
    color: #1976d2;
    margin-bottom: 6px;
    font-weight: 500;
}

.input-wrapper {
    position: relative;
}

.input-wrapper input {
    width: 100%;
    padding: 14px 14px 14px 54px;
    border-radius: 30px;
    border: 1px solid #cfdff5;
    font-size: 14px;
    outline: none;
}

.input-wrapper input::placeholder {
    color: #90a4c3;
}

.icon-circle {
    position: absolute;
    top: 50%;
    left: 8px;
    transform: translateY(-50%);
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: linear-gradient(135deg, #64b5f6, #1e88e5);
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    font-size: 15px;
}

.signup-btn {
    margin-top: 32px;
    width: 100%;
    border: none;
    outline: none;
    padding: 15px;
    border-radius: 30px;
    background: linear-gradient(135deg, #64b5f6, #1e88e5);
    color: #fff;
    font-size: 15px;
    font-weight: 500;
    cursor: pointer;
}

.signup-btn:hover {
    opacity: 0.95;
}

/* MOBILE */
@media (max-width: 700px) {
    .form-grid {
        grid-template-columns: 1fr;
    }

    .form-group.full {
        grid-column: span 1;
    }

    .signup-card {
        padding: 28px 20px;
    }

    .signup-card h1 {
        font-size: 22px;
    }
}
</style>
</head>

<body>

<div class="signup-card">

    <div class="logo">
        <img src="votinglogo.jpg" alt="E Voting Logo">
    </div>

    <h1>E-VOTING REGISTRATION</h1>

    <?php if ($message): ?>
        <p style="color:red; margin-bottom:18px;"><?php echo $message; ?></p>
    <?php endif; ?>

    <form method="POST">

        <div class="form-grid">

            <div class="form-group">
                <label>Name</label>
                <div class="input-wrapper">
                    <div class="icon-circle"><i class="fa-regular fa-user"></i></div>
                    <input type="text" name="name" placeholder="enter full name" required>
                </div>
            </div>

            <div class="form-group">
                <label>User Email</label>
                <div class="input-wrapper">
                    <div class="icon-circle"><i class="fa-regular fa-envelope"></i></div>
                    <input type="email" name="email" placeholder="enter email address" required>
                </div>
            </div>

            <div class="form-group">
                <label>Year of Birth</label>
                <div class="input-wrapper">
                    <div class="icon-circle"><i class="fa-regular fa-calendar"></i></div>
                    <input type="number" name="year" placeholder="eg 2002" required>
                </div>
            </div>

            <div class="form-group">
                <label>Password</label>
                <div class="input-wrapper">
                    <div class="icon-circle"><i class="fa-solid fa-lock"></i></div>
                    <input type="password" name="password" placeholder="create password" required>
                </div>
            </div>

            <div class="form-group full">
                <label>Confirm Password</label>
                <div class="input-wrapper">
                    <div class="icon-circle"><i class="fa-solid fa-lock"></i></div>
                    <input type="password" name="confirm_password" placeholder="re-enter password" required>
                </div>
            </div>

        </div>

        <button class="signup-btn">REGISTER</button>

    </form>

</div>

</body>
</html>
