<?php
session_start();
require_once "db.php";
require_once "user.php";

$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $email    = trim($_POST["email"]);
    $password = $_POST["password"];

    if (empty($email) || empty($password)) {
        $message = "All fields are required";
    } else {
        try {
            $db   = new Database();
            $conn = $db->connect();
            $user = new User($conn);

            $loggedUser = $user->login($email, $password);

            if ($loggedUser) {

                $_SESSION["user_id"]   = $loggedUser["id"];
                $_SESSION["name"]      = $loggedUser["name"];
                $_SESSION["has_voted"] = $loggedUser["has_voted"];
                $_SESSION["is_admin"]  = $loggedUser["is_admin"];

                if ($loggedUser["is_admin"] == 1) {
                    header("Location: votings.php");
                } else {
                    header("Location: candidates.php");
                }
                exit;

            } else {
                $message = "Invalid email or password";
            }

        } catch (Exception $e) {
            $message = "Error: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>E Voting Login</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Poppins', sans-serif;
}

body {
    min-height: 100vh;
    background: #eef6ff;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

.login-card {
    width: 520px;
    max-width: 100%;
    background: #ffffff;
    border-radius: 14px;
    padding: 40px;
    box-shadow: 0 10px 25px rgba(0, 123, 255, 0.15);
    text-align: center;
}

.logo {
    width: 64px;
    height: 64px;
    margin: 0 auto 12px;
}

.logo img {
    width: 100%;
    height: 100%;
    object-fit: contain;
}

.login-card h1 {
    font-size: 24px;
    font-weight: 600;
    margin-bottom: 20px;
    color: #0d47a1;
}

.form-group {
    margin-bottom: 20px;
    text-align: left;
}

.form-group label {
    display: block;
    font-size: 14px;
    color: #1976d2;
    margin-bottom: 6px;
    font-weight: 500;
}

.input-wrapper {
    position: relative;
}

.input-wrapper input {
    width: 100%;
    padding: 14px 14px 14px 54px;
    border-radius: 30px;
    border: 1px solid #cfdff5;
    font-size: 14px;
    outline: none;
}

.icon-circle {
    position: absolute;
    top: 50%;
    left: 8px;
    transform: translateY(-50%);
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: linear-gradient(135deg, #64b5f6, #1e88e5);
    display: flex;
    align-items: center;
    justify-content: center;
    color: #fff;
    font-size: 15px;
}

.login-btn {
    margin-top: 26px;
    width: 100%;
    border: none;
    outline: none;
    padding: 15px;
    border-radius: 30px;
    background: linear-gradient(135deg, #64b5f6, #1e88e5);
    color: #fff;
    font-size: 15px;
    font-weight: 500;
    cursor: pointer;
}

.login-btn:hover {
    opacity: 0.95;
}

/* ---------------- MOBILE RESPONSIVENESS ---------------- */
@media (max-width: 480px) {

    .login-card {
        padding: 28px 22px;
        border-radius: 12px;
    }

    .logo {
        width: 54px;
        height: 54px;
        margin-bottom: 10px;
    }

    .login-card h1 {
        font-size: 20px;
        margin-bottom: 16px;
    }

    .form-group label {
        font-size: 13px;
    }

    .input-wrapper input {
        padding: 13px 14px 13px 52px;
        font-size: 13px;
    }

    .icon-circle {
        width: 34px;
        height: 34px;
        font-size: 14px;
    }

    .login-btn {
        padding: 14px;
        font-size: 14px;
        margin-top: 22px;
    }
}
</style>
</head>

<body>

<div class="login-card">

    <div class="logo">
        <img src="votinglogo.jpg" alt="E Voting Logo">
    </div>

    <h1>E VOTING LOGIN</h1>

    <?php if ($message): ?>
        <p style="color:red; margin-bottom:15px;"><?php echo $message; ?></p>
    <?php endif; ?>

    <form method="POST">

        <div class="form-group">
            <label>User Email</label>
            <div class="input-wrapper">
                <div class="icon-circle"><i class="fa-regular fa-envelope"></i></div>
                <input 
                    type="email" 
                    name="email" 
                    placeholder="enter your email address"
                    required
                >
            </div>
        </div>

        <div class="form-group">
            <label>Password</label>
            <div class="input-wrapper">
                <div class="icon-circle"><i class="fa-solid fa-lock"></i></div>
                <input 
                    type="password" 
                    name="password" 
                    placeholder="enter your password"
                    required
                >
            </div>
        </div>

        <button class="login-btn">LOGIN</button>

    </form>

</div>

</body>
</html>
