<?php
session_start();
require_once "db.php";

if (!isset($_SESSION["user_id"])) {
    header("Location: index.php");
    exit;
}

$db = new Database();
$conn = $db->connect();

$userId   = $_SESSION["user_id"];
$hasVoted = $_SESSION["has_voted"] ?? 0;

$showSuccessModal = false;
$showAlreadyModal = false;
$votedCandidate   = "";

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["candidate_id"])) {

    if ($hasVoted == 1) {
        $showAlreadyModal = true;
    } else {
        $candidateId = (int) $_POST["candidate_id"];

        $stmt = $conn->prepare(
            "INSERT INTO votes (user_id, candidate_id) VALUES (?, ?)"
        );
        $stmt->execute([$userId, $candidateId]);

        $stmt = $conn->prepare(
            "UPDATE users SET has_voted = 1 WHERE id = ?"
        );
        $stmt->execute([$userId]);

        $_SESSION["has_voted"] = 1;
        $hasVoted = 1;

        $stmt = $conn->prepare("SELECT name FROM candidates WHERE id = ?");
        $stmt->execute([$candidateId]);
        $votedCandidate = $stmt->fetchColumn();

        $showSuccessModal = true;
    }
}

if (isset($_GET["logout"])) {
    session_destroy();
    header("Location: index.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>E Voting – Candidates</title>

<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
/* styles unchanged */
*{margin:0;padding:0;box-sizing:border-box;font-family:'Poppins',sans-serif}
body{min-height:100vh;background:#eef6ff;display:flex;justify-content:center;padding:40px 16px}

.page-card{width:1100px;max-width:100%;background:#fff;border-radius:16px;padding:40px;box-shadow:0 10px 25px rgba(0,123,255,.15)}
.page-header{text-align:center;margin-bottom:40px}
.page-header img{width:64px;margin-bottom:12px}
.page-header h1{font-size:26px;color:#0d47a1}
.page-header p{font-size:14px;color:#5f7da3}

.candidate-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:24px}

.candidate-card{
    background:#f8fbff;border-radius:14px;padding:22px;
    text-align:center;border:1px solid #dbe8f7
}

.candidate-card img{
    width:100px;height:100px;border-radius:50%;
    border:3px solid #64b5f6;margin-bottom:14px;
    object-fit:cover
}

.candidate-card h3{font-size:16px;color:#0d47a1}
.candidate-card span{font-size:13px;color:#5f7da3;display:block;margin-bottom:18px}

.vote-btn{
    width:100%;padding:12px;border-radius:30px;border:none;
    cursor:pointer;color:#fff;
    background:linear-gradient(135deg,#64b5f6,#1e88e5);
    font-size:14px;font-weight:500;
    display:flex;align-items:center;justify-content:center;gap:8px
}

.vote-btn:disabled{opacity:.6;cursor:not-allowed}

.modal-overlay{
    position:fixed;inset:0;background:rgba(0,0,0,.45);
    display:flex;align-items:center;justify-content:center;z-index:999
}

.modal{
    width:420px;background:#fff;border-radius:14px;
    padding:30px;text-align:center
}

.modal h2{margin-bottom:10px;color:#0d47a1}
.modal p{font-size:14px;color:#5f7da3}

.logout-btn{
    margin-top:25px;padding:12px 32px;border-radius:30px;
    border:none;background:linear-gradient(135deg,#64b5f6,#1e88e5);
    color:#fff;cursor:pointer
}

@media(max-width:1024px){
    .candidate-grid{grid-template-columns:repeat(2,1fr)}
}
@media(max-width:600px){
    .page-card{padding:26px 20px}
    .candidate-grid{grid-template-columns:1fr}
}
</style>
</head>

<body>

<div class="page-card">
    <div class="page-header">
        <img src="votinglogo.jpg">
        <h1>Select Your Candidate</h1>
        <p>You can only vote once</p>
    </div>

    <div class="candidate-grid">
        <?php
        $candidates = $conn->query("SELECT * FROM candidates")->fetchAll(PDO::FETCH_ASSOC);
        foreach ($candidates as $c):

            $imagePath = !empty($c["image"])
                ? "images/" . $c["image"]
                : "images/default.png";
        ?>
        <div class="candidate-card">
            <img src="<?= htmlspecialchars($imagePath) ?>" alt="candidate">
            <h3><?= htmlspecialchars($c["name"]) ?></h3>
            <span><?= htmlspecialchars($c["position"]) ?></span>

            <form method="POST">
                <input type="hidden" name="candidate_id" value="<?= $c["id"] ?>">
                <button class="vote-btn" <?= $hasVoted ? "disabled" : "" ?>>
                    Vote <i class="fa-solid fa-check-to-slot"></i>
                </button>
            </form>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<?php if ($showSuccessModal): ?>
<div class="modal-overlay">
    <div class="modal">
        <h2>Vote Successful</h2>
        <p>You voted for <strong><?= htmlspecialchars($votedCandidate) ?></strong></p>
        <form method="GET">
            <button name="logout" class="logout-btn">Log Out</button>
        </form>
    </div>
</div>
<?php endif; ?>

<?php if ($showAlreadyModal): ?>
<div class="modal-overlay">
    <div class="modal">
        <h2>Already Voted</h2>
        <p>You have already cast your vote.</p>
        <form method="GET">
            <button name="logout" class="logout-btn">Log Out</button>
        </form>
    </div>
</div>
<?php endif; ?>

</body>
</html>
